unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ImgList;

type
  // dla Rysuj
  MyFunc1 = function(parCanvas: TCanvas) : Integer; stdcall;
  // dla GetLibVersion
  MyFunc2 = function() : PChar; stdcall;
  // dla GetNI
  MyFunc3 = procedure(var nazwisko : PChar; var imnie : PChar); stdcall;
  // dla Kwadrat
  MyFunc4 = function(cyfra : Integer) : LongInt; stdcall;

  TForm1 = class(TForm)
    Panel1: TPanel;
    btnClose: TBitBtn;
    btnRectangles: TBitBtn;
    btnVersion: TBitBtn;
    btnNI: TBitBtn;
    btnKwadrat: TBitBtn;
    procedure btnKwadratClick(Sender: TObject);
    procedure btnNIClick(Sender: TObject);
    procedure btnVersionClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnRectanglesClick(Sender: TObject);
  private

  public

  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.btnCloseClick(Sender: TObject);
begin
	Close();
end;

procedure TForm1.btnRectanglesClick(Sender: TObject);
var
   HInst     : THandle;
   FPointer  : TFarProc;	//   TFarProc = Pointer;
   probaFunc : MyFunc1;
   ACanvas   : TCanvas;

begin
   HInst := SafeLoadLibrary('Pierwsza.dll');

   if HInst > 0 then
   begin
      try
         FPointer := GetProcAddress(HInst, PChar('Rysuj'));

         if FPointer <> Nil then
         begin
            probaFunc := MyFunc1(FPointer);
            ACanvas   := Form1.Canvas;
            probaFunc(ACanvas);
         end
         else begin
            ShowMessage('DLL function not found');
         end;
      finally
         FreeLibrary(HInst);
      end;
   end
   else begin
      ShowMessage('DLL library not found');
   end;
end;

procedure TForm1.btnNIClick(Sender: TObject);
var
   HInst     : THandle;
   FPointer  : TFarProc;
   probaFunc : MyFunc3;
   nazwisko  : PChar;
   imie      : PChar;

begin
   HInst := SafeLoadLibrary('Pierwsza.dll');

   if HInst > 0 then
   begin
      try
         FPointer := GetProcAddress(HInst, PChar('GetNI'));

         if FPointer <> Nil then
         begin
            probaFunc := MyFunc3(FPointer);
            probaFunc(nazwisko, imie);
            ShowMessage('Funkcja z DLL zwrcia warto: ' + nazwisko + ' ' + imie);
         end
         else begin
            ShowMessage('DLL function not found');
         end;
      finally
         FreeLibrary(HInst);
      end;
   end
   else begin
      ShowMessage('DLL library not found');
   end;
end;

procedure TForm1.btnKwadratClick(Sender: TObject);
var
   HInst     : THandle;
   FPointer  : TFarProc;
   probaFunc : MyFunc4;
   cyfra     : Integer;
   wynik     : LongInt;

begin
   HInst := SafeLoadLibrary('Pierwsza.dll');

   if HInst > 0 then
   begin
      try
         FPointer := GetProcAddress(HInst, PChar('Kwadrat'));

         if FPointer <> Nil then
         begin
            probaFunc := MyFunc4(FPointer);
            cyfra := 12;
            wynik := probaFunc(cyfra);
            ShowMessage('Funkcja z DLL zwrcia warto: ' + IntToStr(wynik));
         end
         else begin
            ShowMessage('DLL function not found');
         end;
      finally
         FreeLibrary(HInst);
      end;
   end
   else begin
      ShowMessage('DLL library not found');
   end;
end;

procedure TForm1.btnVersionClick(Sender: TObject);
var
   HInst     : THandle;
   FPointer  : TFarProc;
   probaFunc : MyFunc2;
   wersja    : PChar;

begin
   HInst := SafeLoadLibrary('Pierwsza.dll');

   if HInst > 0 then
   begin
      try
         FPointer := GetProcAddress(HInst, PChar('GetLibVersion'));

         if FPointer <> Nil then
         begin
            probaFunc := MyFunc2(FPointer);
            wersja    := probaFunc();
            ShowMessage('Funkcja z DLL zwrcia warto: ' + wersja);
         end
         else begin
            ShowMessage('DLL function not found');
         end;
      finally
         FreeLibrary(HInst);
      end;
   end
   else begin
      ShowMessage('DLL library not found');
   end;
end;

end.


